﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CFU_Prod_Lista_Precio]') 
                   and Type = 'FN' )
BEGIN
    DROP FUNCTION dbo.CFU_Prod_Lista_Precio 
END
GO

CREATE FUNCTION [dbo].[CFU_Prod_Lista_Precio](@pId_Lista_Precio SMALLINT, @pId_Producto VARCHAR(14), @pId_Cliente INT, @Fecha DATETIME)
RETURNS DECIMAL(12,2)
AS
BEGIN
DECLARE @Precio									DECIMAL(12,2)
DECLARE @Flag_Existe_Lista_Precio				TINYINT
DECLARE @Flag_Existe_Producto					TINYINT
DECLARE @Flag_Existe_Cliente					TINYINT
DECLARE @Flag_Existe_Producto_En_Lista_Precios	TINYINT
/*=================================================================================*/

SET @Flag_Existe_Lista_Precio = ISNULL((SELECT 1 FROM Prod_Listas_Precios WHERE Id_Lista_Precio = @pId_Lista_Precio), 0)
IF(@pId_Lista_Precio = 0 OR @Flag_Existe_Lista_Precio = 0)
BEGIN
	SET @Precio = 0
	RETURN @Precio
END

SET @Flag_Existe_Producto = ISNULL((SELECT 1 FROM Productos WHERE Id_Producto = @pId_Producto), 0)
IF(@pId_Producto = '' OR @Flag_Existe_Producto = 0)
BEGIN
	SET @Precio = 0
	RETURN @Precio
END

SET @Flag_Existe_Cliente = ISNULL((SELECT 1 FROM Clientes WHERE Id_Cliente = @pId_Cliente), 0)
IF(@pId_Cliente = 0 OR @Flag_Existe_Cliente = 0)
BEGIN
	SET @Precio = 0
	RETURN @Precio
END

SET @Flag_Existe_Producto_En_Lista_Precios = ISNULL((SELECT 1 FROM Prod_Listas_Precios_Items WHERE Id_Lista_Precio = @pId_Lista_Precio AND Id_Producto = @pId_Producto), 0)
IF(@Flag_Existe_Producto_En_Lista_Precios = 0)
BEGIN
	SET @Precio = 0
	RETURN @Precio
END

/*=================================================================================*/

SELECT
@Precio = Precio
FROM Prod_Listas_Precios_Items 
WHERE 
Id_Lista_Precio = @pId_Lista_Precio 
AND Id_Producto = @pId_Producto

/*=================================================================================*/

/*PARA CUALQUIER OTRA PARTICULARIDAD IMPLEMENTAR A PARTIR DE AQUI LA MODIFICACION DE LA VARIABLE @Precio*/

/*=================================================================================*/

RETURN ISNULL(@Precio, 0)
END